@echo off

::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:: Control FMLLMOS
::
:: Copyright: © 2015-2025 Claris International Inc. All rights reserved.
::
:: Environment Variable Prerequisites
::
::   ARGS     start, stop.
::
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

setlocal enabledelayedexpansion

set FMOSLLM_DIR=%~dp0

set MINIFORGE_PATH=%ProgramData%\FileMaker\Open_Source_LLM\server\miniforge3
set FMOSLLM_COMP=FMS.COMPONENT=fmosllm

set LOGS_FILE=%MINIFORGE_PATH%\..\fm_LLMOS_Debug.log
set SCRIPTS_DIR=%MINIFORGE_PATH%\Scripts
set ENV_NAME=fmosllm


>>%LOGS_FILE% 2>&1 (
	echo Running %SCRIPTS_DIR%

	if [%1]==[start] (
		ECHO Starting FMOSLLM
		echo "%SCRIPTS_DIR%\activate.bat" %ENV_NAME%
		call "%SCRIPTS_DIR%\activate.bat" %ENV_NAME%

		if [%2]==[-debug] (
			call python %MINIFORGE_PATH%\..\fm_LLMOS_StartServer.py -bridge -debug %FMOSLLM_COMP%
		) else (
			call python %MINIFORGE_PATH%\..\fm_LLMOS_StartServer.pyc -bridge %FMOSLLM_COMP%
		)
	) 

	if [%1]==[stop] (
		tasklist /fi "imagename eq python.exe" /nh |find /i /c "python.exe"|findstr "^2$" >nul && taskkill /f /im python.exe
	)
)

GOTO :EOF

endlocal 
